/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.result;

import cz.insophy.inplan.report.ReportUtilities;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Workplace;
import java.io.Serializable;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public class WorkplaceUsageTableRow
implements Comparable<WorkplaceUsageTableRow>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final long total;
    private final long production;
    private final long pastProduction;
    private final long rebuild;
    private final long pastRebuild;
    private final long offline;
    private final long waiting;
    private final int gors;
    private final CapabilityIsland island;
    private final double productionCost;
    private final double rebuildCost;

    public WorkplaceUsageTableRow(Workplace workplace, long total, long production, long pastProduction, long rebuild, long pastRebuild, long offline, long waiting, int gors, double productionCost, double rebuildCost) {
        this(workplace.getName(), workplace.getDescription(), total, production, pastProduction, rebuild, pastRebuild, offline, waiting, gors, null, productionCost, rebuildCost);
    }

    public WorkplaceUsageTableRow(CapabilityIsland island, long total, long production, long pastProduction, long rebuild, long pastRebuild, long offline, long waiting, int gors, double productionCost, double rebuildCost) {
        this(island.getName(), WorkplaceUsageTableRow.extractDescription(island), total, production, pastProduction, rebuild, pastRebuild, offline, waiting, gors, island, productionCost, rebuildCost);
    }

    private static String extractDescription(CapabilityIsland island) {
        TreeSet<String> set = new TreeSet<String>();
        for (Workplace w : island.getWorkplaces()) {
            set.add(w.getDescription());
        }
        return ((Object)set).toString();
    }

    private WorkplaceUsageTableRow(String name, String description, long total, long production, long pastProduction, long rebuild, long pastRebuild, long offline, long waiting, int gors, CapabilityIsland island, double productionCost, double rebuildCost) {
        this.name = name;
        this.description = description;
        this.total = total;
        this.production = production;
        this.pastProduction = pastProduction;
        this.rebuild = rebuild;
        this.pastRebuild = pastRebuild;
        this.offline = offline;
        this.waiting = waiting;
        this.gors = gors;
        this.island = island;
        this.productionCost = productionCost;
        this.rebuildCost = rebuildCost;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTotalTime() {
        return this.total;
    }

    public long getProductionTime() {
        return this.production;
    }

    public long getPastProductionTime() {
        return this.pastProduction;
    }

    public double getProductionCost() {
        return this.productionCost;
    }

    public long getRebuildTime() {
        return this.rebuild;
    }

    public long getPastRebuildTime() {
        return this.pastRebuild;
    }

    public double getRebuildCost() {
        return this.rebuildCost;
    }

    public long getOfflineTime() {
        return this.offline;
    }

    public long getWaitingTime() {
        return this.waiting;
    }

    public long getAverageProductionTime() {
        if (this.gors == 0) {
            return 0L;
        }
        return this.getProductionTime() / (long)this.gors;
    }

    public long getAverageWaitingTime() {
        if (this.gors == 0) {
            return 0L;
        }
        return this.getWaitingTime() / (long)this.gors;
    }

    public int getGorCount() {
        return this.gors;
    }

    public long getOnlineTime() {
        return Math.max(0L, this.getTotalTime() - this.getOfflineTime());
    }

    public long getUsedTime() {
        return Math.max(0L, this.getProductionTime() + this.getRebuildTime());
    }

    public double getProductionRatio() {
        double nom = this.getProductionTime();
        double denom = this.getUsedTime();
        return ReportUtilities.getSafeRatio(nom, denom);
    }

    public double getUsedRatio() {
        double nom = this.getUsedTime();
        double denom = this.getOnlineTime();
        return ReportUtilities.getSafeRatio(nom, denom);
    }

    public CapabilityIsland getIsland() {
        return this.island;
    }

    @Override
    public int compareTo(@Nonnull WorkplaceUsageTableRow o) {
        return this.name.compareToIgnoreCase(o.name);
    }
}

